/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.example.fruitties.kmptutorial.android.network

import com.example.fruitties.kmptutorial.android.model.Fruittie
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class FruittiesResponse(
    @SerialName("feed")
    val feed: List<FruittieNetworkEntity>,
    @SerialName("totalPages")
    val totalPages: Int,
    @SerialName("currentPage")
    val currentPage: Int,
)

@Serializable
data class FruittieNetworkEntity(
    @SerialName("name")
    val name: String,
    @SerialName("full_name")
    val fullName: String,
    @SerialName("calories")
    val calories: String,
)

fun FruittieNetworkEntity.toModel() = Fruittie(
    name = name,
    fullName = fullName,
    calories = calories,
)
